/* <nagg11.h>
 *
 * Copyright 1996 Numerical Algorithms Group
 *
 * Include file for NAG C Library g11 Chapter
 *
 * Mark 4, revised, 1996.
 * Mark 5 revised. IER-2160 (Feb 1998).
 * Mark 6 revised. IER-3047 (July 2000).
 */
#ifndef NAGG11
#define NAGG11

/// ML 9/22/2004 COMPILING_ONAG8HEADERS_IN_OC
#ifndef _MSC_VER	   //VC
	// This must be put into every header since it does not appear to be
	// inheritable from parent header to child (#include-ded) header:
	#pragma dll(ONAG8)
#endif // !_MSC_VER	   //VC
/// end COMPILING_ONAG8HEADERS_IN_OC

#ifdef __cplusplus
extern "C"
{
#endif
  /* begin proto */
  extern NAG_DLL_EXPIMP void NAG_CALL g11aac(Integer nrow, Integer ncol, Integer nobst[], Integer tdt,
                                             double expt[], double chist[], double *prob,
                                             double *chi, double *g, double *df,  NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL g11bac(Nag_TableStats stat, Nag_TableUpdate update, Nag_Weightstype weight, Integer n,
                     Integer nfac, const Integer sf[], const Integer lfac[], const Integer factor[],
                     Integer tdf, const double y[], const double wt[], double table[],
                     Integer maxt, Integer *ncells, Integer *ndim, Integer idim[],
                     Integer count[], double comm_ar[], NagError *fail);
  extern void g11baf_f(char *stat, char *update, char *weight, Integer n,
                       Integer nfac, const Integer isf[], const Integer lfac[], const Integer ifac[],
                       Integer ldf, const double y[], const double wt[], double table[],
                       Integer maxt, Integer *ncells, Integer *ndim, Integer idim[],
                       Integer icount[], double auxt[], Integer iwk[], Integer *ifail,
                       Integer stat_len, Integer update_len, Integer weight_len);
  extern NAG_DLL_EXPIMP void NAG_CALL g11bbc( Nag_TabulateVar  type, Integer n, Integer nfac,
                      const Integer isf[], const Integer lfac[], const Integer ifac[], Integer ldf,
                      double percnt, const double y[], const double wt[], double table[],
                      Integer maxt, Integer *ncells, Integer *ndim, Integer idim[],
                      Integer icount[], NagError *fail);
  extern void g11bbf_f(char *type, char *weight, Integer n, Integer nfac,
                       const Integer isf[], const Integer lfac[], const Integer ifac[], Integer ldf,
                       double percnt, const double y[], const double wt[], double table[],
                       Integer maxt, Integer *ncells, Integer *ndim, Integer idim[],
                       Integer icount[], Integer iwk[], double wk[], Integer *ifail,
                       Integer type_len, Integer weight_len);

extern NAG_DLL_EXPIMP void NAG_CALL g11bcc(Nag_TableStats stat, const double table[], Integer ncells, Integer ndim, const Integer idim[], const Integer isdim[], double sub_table[], Integer maxst, Integer *mcells, Integer *mdim, Integer mlevel[], double comm_ar[], NagError *fail); 

extern NAG_DLL_EXPIMP void NAG_CALL g11cac(Nag_OrderType order, Integer n, Integer m, Integer ns, const double z[], Integer pdz, const Integer isz[], Integer p, const Integer ic[], const Integer isi[], double *dev, double b[], double se[], double sc[], double cov[], Integer nca[], Integer nct[], double tol, Integer maxit, Integer iprint, const char *outfile, NagError *fail); 

extern NAG_DLL_EXPIMP void NAG_CALL g11sac(Nag_OrderType order, Integer p, Integer n, Boolean gprob, Integer ns, Boolean x[], Integer pdx, Integer irl[], double a[], double c[], Integer iprint, const char *outfile, double cgetol, Integer maxit, Boolean chisqr, Integer *niter, double alpha[], double pigam[], double cm[], Integer pdcm, double g[], double expp[], Integer pde, double obs[], double exf[], double y[], Integer iob[], double *rlogl, double *chi, Integer *idf, double *siglev, NagError *fail); 

extern NAG_DLL_EXPIMP void NAG_CALL g11sbc(Nag_OrderType order, Integer p, Integer n, Integer *ns, Boolean x[], Integer nrx, Integer irl[], NagError *fail); 


  /* end proto */
#ifdef __cplusplus
}
#endif
#endif /* not NAGG11 */

